<?php
namespace App;

use PDO;
use PDOException;

class Database {
    public static function connect() {
        $env = parse_ini_file(__DIR__ . '/../.env');

        $dsn = "sqlsrv:Server={$env['DB_HOST']},{$env['DB_PORT']};Database={$env['DB_DATABASE']}";
        $user = $env['DB_USERNAME'];
        $pass = $env['DB_PASSWORD'];

        try {
            $pdo = new PDO($dsn, $user, $pass);
            $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            return $pdo;
        } catch (PDOException $e) {
            http_response_code(500);
            echo json_encode(['error' => 'Conexión fallida', 'detalle' => $e->getMessage()]);
            exit;
        }
    }
}
