<?php
use App\Database;

require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../vendor/autoload.php';

// Autenticación básica manual
$env = parse_ini_file(__DIR__ . '/../.env');
$validUser = $env['API_USER'] ?? '';
$validPass = $env['API_PASS'] ?? '';

// Fallback por HTTP_AUTHORIZATION si no viene PHP_AUTH_USER
if (!isset($_SERVER['PHP_AUTH_USER'])) {
    if (isset($_SERVER['HTTP_AUTHORIZATION']) && stripos($_SERVER['HTTP_AUTHORIZATION'], 'basic') === 0) {
        $encoded = substr($_SERVER['HTTP_AUTHORIZATION'], 6);
        $decoded = base64_decode($encoded);
        if ($decoded) {
            list($_SERVER['PHP_AUTH_USER'], $_SERVER['PHP_AUTH_PW']) = explode(':', $decoded, 2);
        }
    }
}

$inputUser = $_SERVER['PHP_AUTH_USER'] ?? null;
$inputPass = $_SERVER['PHP_AUTH_PW'] ?? null;

if ($inputUser !== $validUser || $inputPass !== $validPass) {
    http_response_code(401);
    echo json_encode([
        'isSuccess' => false,
        'httpStatusCode' => 401,
        'message' => 'No autorizado, faltan credenciales',
        'data' => []
    ]);
    exit;
}

// Verificar método permitido
if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    http_response_code(400);
    echo json_encode([
        'isSuccess' => false,
        'httpStatusCode' => 400,
        'message' => 'Método no permitido, solo GET',
        'data' => []
    ]);
    exit;
}

try {
    $conn = Database::connect();

    $sql = "SELECT
        numero,
        nombre_completo,
        N_I_T,
        EMAIL,
        TIPO_CREDITO,
        CONTACTO_1,
        TELEFONOS
    FROM cliente
    WHERE estatus = 'A'";

    $stmt = $conn->query($sql);

    $clientes = [];
    $format = fn($value) => trim($value) !== '' ? trim($value) : ' ';

    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $clientes[] = [
            'Identificacion sistema web' => $format($row['numero']),
            'Nombre comercial' => $format($row['nombre_completo']),
            'Nit' => $format($row['N_I_T']),
            'Correo' => $format($row['EMAIL']),
            'Tipo credito' => $format($row['TIPO_CREDITO']),
            'Contacto principal Nombre' => $format($row['CONTACTO_1']),
            'Contacto principal Telefono' => $format($row['TELEFONOS']),
        ];
    }

    http_response_code(200);
    echo json_encode([
        'isSuccess' => true,
        'httpStatusCode' => 200,
        'message' => 'Consulta exitosa',
        'data' => $clientes
    ], JSON_PRETTY_PRINT);

} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode([
        'isSuccess' => false,
        'httpStatusCode' => 500,
        'message' => 'Error inesperado ocurrido en el servidor',
        'data' => []
    ]);
    exit;
}
