<?php
use App\Database;

require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../vendor/autoload.php';

// Autenticación básica manual
$env = parse_ini_file(__DIR__ . '/../.env');
$validUser = $env['API_USER'] ?? '';
$validPass = $env['API_PASS'] ?? '';

if (!isset($_SERVER['PHP_AUTH_USER'])) {
    if (isset($_SERVER['HTTP_AUTHORIZATION']) && stripos($_SERVER['HTTP_AUTHORIZATION'], 'basic') === 0) {
        $encoded = substr($_SERVER['HTTP_AUTHORIZATION'], 6);
        $decoded = base64_decode($encoded);
        if ($decoded) {
            list($_SERVER['PHP_AUTH_USER'], $_SERVER['PHP_AUTH_PW']) = explode(':', $decoded, 2);
        }
    }
}

$inputUser = $_SERVER['PHP_AUTH_USER'] ?? null;
$inputPass = $_SERVER['PHP_AUTH_PW'] ?? null;

if ($inputUser !== $validUser || $inputPass !== $validPass) {
    http_response_code(401);
    echo json_encode([
        'isSuccess' => false,
        'httpStatusCode' => 401,
        'message' => 'No autorizado, faltan credenciales',
        'data' => []
    ]);
    exit;
}

// Verificar método POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode([
        'isSuccess' => false,
        'httpStatusCode' => 405,
        'message' => 'Método no permitido',
        'data' => []
    ]);
    exit;
}

// Obtener y validar JSON del body
$input = json_decode(file_get_contents("php://input"), true);

$orderWeb = $input['orderWeb'] ?? null;
$customerCode = $input['customerCode'] ?? null;
$noCoordination = $input['noCoordination'] ?? null;

if (!$orderWeb || !$customerCode || $noCoordination === null) {
    http_response_code(400);
    echo json_encode([
        'isSuccess' => false,
        'httpStatusCode' => 400,
        'message' => 'Faltan parámetros en la URL',
        'data' => []
    ]);
    exit;
}

try {
    $conn = Database::connect();

    // Verificamos existencia de la orden
    $stmt = $conn->prepare("SELECT id, CLIENTE FROM ot WHERE CONCAT(numero, '-', anio) = ?");
    $stmt->execute([$orderWeb]);
    $orden = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$orden) {
        http_response_code(404);
        echo json_encode([
            'isSuccess' => false,
            'httpStatusCode' => 404,
            'message' => 'Orden no encontrada',
            'data' => []
        ]);
        exit;
    }

    if ($orden['CLIENTE'] != $customerCode) {
        http_response_code(403);
        echo json_encode([
            'isSuccess' => false,
            'httpStatusCode' => 403,
            'message' => 'La orden existe pero no corresponde al cliente indicado',
            'data' => []
        ]);
        exit;
    }

    // Ejecutar el UPDATE
    $stmt = $conn->prepare("UPDATE ot SET noCoordination = ? WHERE id = ?");
    $stmt->execute([$noCoordination, $orden['id']]);

    http_response_code(200);
    echo json_encode([
        'isSuccess' => true,
        'httpStatusCode' => 200,
        'message' => 'Número de coordinación actualizado correctamente',
        'data' => []
    ]);

} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode([
        'isSuccess' => false,
        'httpStatusCode' => 500,
        'message' => 'Error al actualizar número de coordinación: ' . $e->getMessage(),
        'data' => []
    ]);
    exit;
}

