<?php
namespace Utils;

class DotEnv {
    protected $path;

    public function __construct($path) {
        if (!file_exists($path)) {
            throw new \InvalidArgumentException("Archivo .env no encontrado: $path");
        }
        $this->path = $path;
    }

    public function load() {
        $lines = file($this->path, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
        foreach ($lines as $line) {
            if (strpos(trim($line), '#') === 0) continue;
            list($key, $value) = explode('=', $line, 2);
            $_ENV[trim($key)] = trim($value);
        }
    }
}
